/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.summary;

import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkParticipant;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.VWTrkWorkObject;
import filenet.vw.toolkit.runtime.dialog.VWLockWork;
import filenet.vw.toolkit.runtime.dialog.VWStatusDetailsDialog;
import filenet.vw.toolkit.runtime.dialog.VWUnlockWork;
import filenet.vw.toolkit.runtime.summary.VWTrackerSummaryInfo;
import filenet.vw.toolkit.runtime.summary.VWWorkItemTableModel;
import filenet.vw.toolkit.runtime.summary.images.VWImageLoader;
import filenet.vw.toolkit.runtime.summary.resources.VWResource;
import filenet.vw.toolkit.runtime.table.VWTrackerSummaryCellRenderer;
import filenet.vw.toolkit.utils.VWPopupMenu;
import filenet.vw.toolkit.utils.dialog.VWInformationStackDialog;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableHeaderRenderer;
import filenet.vw.toolkit.utils.table.VWTableSorter;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class VWWorkItemTable
extends VWTable
implements MouseListener,
ListSelectionListener {
    protected Frame m_parentFrame = null;
    private VWTrackerSummaryInfo m_summaryPanel = null;
    private boolean m_initialized = false;
    private VWWorkItemTableModel m_tableModel = null;
    private VWTableSorter m_tableSorter = null;
    private ListSelectionModel m_lsm = null;
    private VWTrackerSummaryCellRenderer m_renderer = null;
    private VWPopupMenu m_popup = null;
    private JMenuItem m_miDisplayStep = null;
    private ActionListener m_miDisplayStepActionListener = null;
    private JMenuItem m_miStatusDetails = null;
    private ActionListener m_miStatusDetailsActionListener = null;
    private JMenuItem m_miInformationStack = null;
    private ActionListener m_miInformationStackActionListener = null;
    private JMenuItem m_miLock = null;
    private ActionListener m_miLockActionListener = null;
    private JMenuItem m_miUnlock = null;
    private ActionListener m_miUnlockActionListener = null;
    protected TableColumnModel m_columnModel = null;
    private int m_popupRow = -1;
    private boolean m_tabSelected = true;

    public VWWorkItemTable(Frame parentFrame, VWTrackerSummaryInfo summaryPanel, VWWorkItemTableModel tableModel) {
        super(tableModel);
        this.m_parentFrame = parentFrame;
        this.m_summaryPanel = summaryPanel;
        this.m_tableModel = tableModel;
        this.init();
    }

    public VWWorkItemTable(Frame parentFrame, VWTableSorter tableSorter) {
        super(tableSorter);
        this.m_parentFrame = parentFrame;
        TableModel tm = null;
        this.m_tableSorter = tableSorter;
        tm = tableSorter.getModel();
        if (tm != null && tm instanceof VWWorkItemTableModel) {
            this.m_tableModel = (VWWorkItemTableModel)tm;
        }
        this.init();
    }

    private void init() {
        this.m_columnModel = this.getColumnModel();
        this.m_renderer = new VWTrackerSummaryCellRenderer();
        TableColumn mapNameColumn = this.m_columnModel.getColumn(0);
        mapNameColumn.setCellRenderer(this.m_renderer);
        TableColumn stepNameColumn = this.m_columnModel.getColumn(1);
        stepNameColumn.setCellRenderer(this.m_renderer);
        TableColumn statusColumn = this.m_columnModel.getColumn(5);
        statusColumn.setCellRenderer(this.m_renderer);
        TableColumn participantColumn = this.m_columnModel.getColumn(3);
        participantColumn.setCellRenderer(this.m_renderer);
        TableColumn receivedDateColumn = this.m_columnModel.getColumn(4);
        receivedDateColumn.setCellRenderer(this.m_renderer);
        TableColumn occurrenceColumn = this.m_columnModel.getColumn(2);
        occurrenceColumn.setMinWidth(40);
        occurrenceColumn.setMaxWidth(40);
        occurrenceColumn.setHeaderRenderer(new VWTableHeaderRenderer(VWImageLoader.createImageIcon("occurrence.gif"), VWResource.s_occurrence));
        occurrenceColumn.setCellRenderer(this.m_renderer);
        TableColumn responseColumn = this.m_columnModel.getColumn(6);
        responseColumn.setCellRenderer(this.m_renderer);
        TableColumn commentsColumn = this.m_columnModel.getColumn(7);
        commentsColumn.setCellRenderer(this.m_renderer);
        this.setShowGrid(false);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setSelectionMode(0);
        this.initColumns();
        this.m_lsm = this.getSelectionModel();
        this.m_lsm.addListSelectionListener(this);
        this.m_initialized = true;
        this.addMouseListener(this);
    }

    protected void initColumns() {
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void createPopup(MouseEvent evt) {
        Vector selectedWork;
        VWTrkDataModel dataModel;
        Object source = evt.getSource();
        if (source != this) {
            return;
        }
        Point point = evt.getPoint();
        int row = this.rowAtPoint(point);
        int col = this.columnAtPoint(point);
        if (row == -1 || col == -1) {
            return;
        }
        if (this.m_tableSorter != null) {
            row = this.m_tableSorter.getRowNumber(row);
        }
        if ((dataModel = this.getDataModel()) == null) {
            return;
        }
        col = this.convertColumnIndexToModel(col);
        if (!this.isRowSelected(row)) {
            this.setRowSelectionInterval(row, row);
        }
        this.m_popupRow = row;
        if (this.m_popup != null) {
            this.m_popup.removeAll();
        } else {
            this.m_popup = new VWPopupMenu();
        }
        if (this.m_miDisplayStep == null) {
            this.m_miDisplayStep = new JMenuItem(VWResource.s_displayStep);
            this.m_miDisplayStepActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (VWWorkItemTable.this.m_tableModel == null) {
                        return;
                    }
                    VWTrkStepOccurrence stepOccurrence = VWWorkItemTable.this.m_tableModel.getStepOccurrence(VWWorkItemTable.this.m_popupRow);
                    if (stepOccurrence != null && VWWorkItemTable.this.m_summaryPanel != null) {
                        VWWorkItemTable.this.m_summaryPanel.displayStepOccurrence(stepOccurrence, true);
                    }
                }
            };
            this.m_miDisplayStep.addActionListener(this.m_miDisplayStepActionListener);
        }
        this.m_popup.add(this.m_miDisplayStep);
        VWStatusDetailsDialog dialog = this.getStatusDialog();
        if (this.m_miStatusDetails == null) {
            this.m_miStatusDetails = new JMenuItem(VWResource.s_ellipse.toString(VWResource.s_statusDetails));
            this.m_miStatusDetailsActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VWStatusDetailsDialog statusDialog = VWWorkItemTable.this.getStatusDialog();
                    statusDialog = VWWorkItemTable.this.initStatusDialog();
                    if (statusDialog != null) {
                        statusDialog.setVisible(true);
                        VWWorkItemTable.this.setStatusInfo(statusDialog);
                    }
                }
            };
            this.m_miStatusDetails.addActionListener(this.m_miStatusDetailsActionListener);
        }
        this.m_popup.add(this.m_miStatusDetails);
        VWInformationStackDialog informationStackDialog = this.getInformationStackDialog();
        if (this.m_miInformationStack == null) {
            this.m_miInformationStack = new JMenuItem(VWResource.s_ellipse.toString(VWResource.s_informationStackView));
            this.m_miInformationStackActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VWInformationStackDialog informationStackDialog = VWWorkItemTable.this.getInformationStackDialog();
                    informationStackDialog = VWWorkItemTable.this.initInformationStackDialog();
                    if (informationStackDialog != null) {
                        informationStackDialog.setVisible(true);
                        VWWorkItemTable.this.setInformationStackInfo(informationStackDialog);
                    }
                }
            };
            this.m_miInformationStack.addActionListener(this.m_miInformationStackActionListener);
        }
        if ((selectedWork = this.getSelectedWorkInTable()) != null && selectedWork.size() > 0) {
            this.m_popup.add(this.m_miInformationStack);
        }
        if (dataModel.isTracker()) {
            boolean bLockable = this.m_tableModel.isLockable(row);
            boolean bUnlockable = this.m_tableModel.isUnockable(row);
            if (bLockable || bUnlockable) {
                this.m_popup.add(new JSeparator());
            }
            if (bLockable) {
                if (this.m_miLock == null) {
                    this.m_miLock = new JMenuItem(VWResource.s_lock);
                    this.m_miLockActionListener = new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            try {
                                if (VWWorkItemTable.this.m_tableModel == null) {
                                    return;
                                }
                                VWTrkParticipant item = VWWorkItemTable.this.m_tableModel.getItem(VWWorkItemTable.this.m_popupRow);
                                Object lockWork = null;
                                if (item instanceof VWTrkParticipant) {
                                    VWLockWork vWLockWork = new VWLockWork(VWWorkItemTable.this.m_parentFrame, item);
                                }
                            }
                            catch (Exception ex) {
                                VWDebug.logException(ex);
                                JOptionPane.showMessageDialog(VWWorkItemTable.this.m_parentFrame, ex.getLocalizedMessage(), VWResource.s_lock, 1, null);
                            }
                            VWWorkItemTable.this.setRowSelectionInterval(VWWorkItemTable.this.m_popupRow, VWWorkItemTable.this.m_popupRow);
                        }
                    };
                    this.m_miLock.addActionListener(this.m_miLockActionListener);
                }
                this.m_popup.add(this.m_miLock);
            }
            if (bUnlockable) {
                if (this.m_miUnlock == null) {
                    this.m_miUnlock = new JMenuItem(VWResource.s_unlock);
                    this.m_miUnlockActionListener = new ActionListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void actionPerformed(ActionEvent e) {
                            VWUnlockWork unlockWork = null;
                            try {
                                if (VWWorkItemTable.this.m_tableModel == null) {
                                    return;
                                }
                                VWTrkParticipant item = VWWorkItemTable.this.m_tableModel.getItem(VWWorkItemTable.this.m_popupRow);
                                if (item instanceof VWTrkParticipant) {
                                    unlockWork = new VWUnlockWork(VWWorkItemTable.this.m_parentFrame, item);
                                }
                                if (unlockWork != null) {
                                    unlockWork.unlockWork();
                                }
                            }
                            catch (Exception ex) {
                                VWDebug.logException(ex);
                                JOptionPane.showMessageDialog(VWWorkItemTable.this.m_parentFrame, ex.getLocalizedMessage(), VWResource.s_unlock, 1, null);
                            }
                            finally {
                                if (unlockWork != null) {
                                    unlockWork.removeReferences();
                                    unlockWork = null;
                                }
                            }
                            VWWorkItemTable.this.setRowSelectionInterval(VWWorkItemTable.this.m_popupRow, VWWorkItemTable.this.m_popupRow);
                        }
                    };
                    this.m_miUnlock.addActionListener(this.m_miUnlockActionListener);
                }
                this.m_popup.add(this.m_miUnlock);
            }
        }
        this.m_popup.show(this, point.x, point.y);
    }

    private VWStatusDetailsDialog getStatusDialog() {
        if (!this.m_initialized) {
            return null;
        }
        VWTrkDataModel dataModel = this.getDataModel();
        if (dataModel != null) {
            return dataModel.getStatusDetailsDialog();
        }
        return null;
    }

    private void setStatusDialog(VWStatusDetailsDialog statusDialog) {
        VWTrkDataModel dataModel = this.getDataModel();
        if (dataModel != null) {
            dataModel.setStatusDetailsDialog(statusDialog);
        }
    }

    private VWStatusDetailsDialog initStatusDialog() {
        if (!this.m_initialized) {
            return null;
        }
        if (this.getDataModel() == null) {
            return null;
        }
        VWStatusDetailsDialog statusDialog = this.getStatusDialog();
        if (statusDialog == null) {
            if (this.m_lsm != null) {
                this.m_lsm.removeListSelectionListener(this);
            }
            this.m_lsm = this.getSelectionModel();
            this.m_lsm.addListSelectionListener(this);
            statusDialog = new VWStatusDetailsDialog(this.m_parentFrame);
            if (statusDialog != null) {
                this.setStatusDialog(statusDialog);
            }
        }
        return statusDialog;
    }

    private VWInformationStackDialog getInformationStackDialog() {
        if (!this.m_initialized) {
            return null;
        }
        VWTrkDataModel dataModel = this.getDataModel();
        if (dataModel != null) {
            return dataModel.getInformationStackDialog();
        }
        return null;
    }

    private void setInformationStackDialog(VWInformationStackDialog informationStackDialog) {
        VWTrkDataModel dataModel = this.getDataModel();
        if (dataModel != null) {
            dataModel.setInformationStackDialog(informationStackDialog);
        }
    }

    private VWInformationStackDialog initInformationStackDialog() {
        if (!this.m_initialized) {
            return null;
        }
        if (this.getDataModel() == null) {
            return null;
        }
        VWInformationStackDialog informationStackDialog = this.getInformationStackDialog();
        if (informationStackDialog == null) {
            if (this.m_lsm != null) {
                this.m_lsm.removeListSelectionListener(this);
            }
            this.m_lsm = this.getSelectionModel();
            this.m_lsm.addListSelectionListener(this);
            Vector selectedWork = this.getSelectedWorkInTable();
            informationStackDialog = new VWInformationStackDialog(selectedWork, this.m_parentFrame);
            if (informationStackDialog != null) {
                this.setInformationStackDialog(informationStackDialog);
            }
        }
        return informationStackDialog;
    }

    private Vector getSelectedWorkInTable() {
        Vector<VWWorkObject> selectedWork = new Vector<VWWorkObject>();
        int[] rows = this.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            VWTrkWorkObject trkWO = null;
            VWWorkObject workObject = null;
            VWTrkParticipant obj = this.m_tableModel.getItem(rows[i]);
            if (obj == null || !(obj instanceof VWTrkParticipant)) continue;
            VWTrkParticipant participant = obj;
            if (participant != null) {
                trkWO = participant.getParticipantWorkObject();
            }
            if (trkWO != null) {
                workObject = trkWO.getVWWorkObject();
            }
            if (workObject == null) continue;
            selectedWork.addElement(workObject);
        }
        return selectedWork;
    }

    public void tableChanged(TableModelEvent e) {
        int selectedRow = this.getSelectedRow();
        super.tableChanged(e);
        if (!this.m_initialized) {
            return;
        }
        int rows = this.getRowCount();
        if (rows > 0) {
            VWInformationStackDialog informationStackDialog;
            VWStatusDetailsDialog statusDialog;
            this.removeRowSelectionInterval(0, rows - 1);
            if (selectedRow >= 0 && selectedRow < rows) {
                this.setRowSelectionInterval(selectedRow, selectedRow);
            }
            if ((statusDialog = this.getStatusDialog()) != null && statusDialog.isVisible()) {
                this.setStatusInfo(statusDialog);
            }
            if ((informationStackDialog = this.getInformationStackDialog()) != null && informationStackDialog.isVisible()) {
                this.setInformationStackInfo(informationStackDialog);
            }
        }
    }

    void updateStatusDetailsDialog() {
        VWStatusDetailsDialog statusDialog = this.getStatusDialog();
        if (statusDialog != null && statusDialog.isVisible()) {
            this.setStatusInfo(statusDialog);
        }
    }

    private void setStatusInfo(VWStatusDetailsDialog statusDialog) {
        if (this.m_summaryPanel == null || !this.m_tabSelected) {
            return;
        }
        int row = this.getSelectedRow();
        if (row != -1 && this.m_tableSorter != null) {
            row = this.m_tableSorter.getRowNumber(row);
        }
        if (statusDialog != null && statusDialog.isVisible() && this.m_tableModel != null) {
            if (row != -1) {
                statusDialog.setMapName(this.m_tableModel.getValueAt(row, 0));
                statusDialog.setStepName(this.m_tableModel.getValueAt(row, 1));
                statusDialog.setOccurrence(this.m_tableModel.getValueAt(row, 2));
                statusDialog.setParticipant(this.m_tableModel.getValueAt(row, 3));
                statusDialog.setOperation(this.m_tableModel.getOperationName(this.m_tableModel.getParticipantAt(row)));
                statusDialog.setReceived(this.m_tableModel.getValueAt(row, 4));
                statusDialog.setStatus(this.m_tableModel.getValueAt(row, 5));
                statusDialog.setResponse(this.m_tableModel.getValueAt(row, 6));
                statusDialog.setComments(this.m_tableModel.getValueAt(row, 7));
            } else {
                statusDialog.clearAll();
            }
        }
    }

    void updateInformationStackDialog() {
        VWInformationStackDialog informationStackDialog = this.getInformationStackDialog();
        if (informationStackDialog != null && informationStackDialog.isVisible()) {
            this.setInformationStackInfo(informationStackDialog);
        }
    }

    private void setInformationStackInfo(VWInformationStackDialog informationStackDialog) {
        if (this.m_summaryPanel == null || !this.m_tabSelected) {
            return;
        }
        int row = this.getSelectedRow();
        if (row != -1 && this.m_tableSorter != null) {
            row = this.m_tableSorter.getRowNumber(row);
        }
        if (informationStackDialog != null && informationStackDialog.isVisible() && this.m_tableModel != null) {
            Vector<VWWorkObject> selectedWork = new Vector<VWWorkObject>();
            if (row != -1) {
                VWTrkWorkObject trkWO = null;
                VWWorkObject workObject = null;
                VWTrkParticipant obj = this.m_tableModel.getItem(row);
                if (obj != null && obj instanceof VWTrkParticipant) {
                    VWTrkParticipant participant = obj;
                    if (participant != null) {
                        trkWO = participant.getParticipantWorkObject();
                    }
                    if (trkWO != null) {
                        workObject = trkWO.getVWWorkObject();
                    }
                    if (workObject != null) {
                        selectedWork.addElement(workObject);
                    }
                }
            }
            informationStackDialog.updateDialog(selectedWork);
        }
    }

    VWTrkDataModel getDataModel() {
        if (this.m_tableModel != null) {
            return this.m_tableModel.getDataModel();
        }
        return null;
    }

    public void mouseClicked(MouseEvent event) {
        if (!this.m_initialized) {
            return;
        }
        if (event.getSource() != this) {
            return;
        }
        if (event.getClickCount() == 2) {
            VWTrkStepOccurrence stepOccurrence;
            Point point = event.getPoint();
            int row = this.rowAtPoint(point);
            int col = this.columnAtPoint(point);
            if (row == -1 || col == -1) {
                return;
            }
            VWStatusDetailsDialog statusDialog = this.initStatusDialog();
            if (statusDialog != null) {
                statusDialog.setVisible(true);
                this.setStatusInfo(statusDialog);
            }
            if ((stepOccurrence = this.m_tableModel.getStepOccurrence(row)) != null && this.m_summaryPanel != null) {
                this.m_summaryPanel.displayStepOccurrence(stepOccurrence, true);
            }
        } else {
            this.updateStatusDetailsDialog();
            this.updateInformationStackDialog();
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.createPopup(event);
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.createPopup(event);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        this.updateStatusDetailsDialog();
        this.updateInformationStackDialog();
    }

    void tabSelected(boolean selected) {
        this.m_tabSelected = selected;
    }

    public void removeReferences() {
        this.m_parentFrame = null;
        this.m_summaryPanel = null;
        this.removeMouseListener(this);
        if (this.m_lsm != null) {
            this.m_lsm.removeListSelectionListener(this);
            this.m_lsm = null;
        }
        this.m_renderer = null;
        for (int i = 0; i < this.m_columnModel.getColumnCount(); ++i) {
            this.m_columnModel.getColumn(i).setCellRenderer(null);
            this.m_columnModel.getColumn(i).setHeaderRenderer(null);
        }
        if (this.m_popup != null) {
            this.m_popup.removeAll();
            this.m_popup = null;
        }
        if (this.m_miDisplayStep != null) {
            this.m_miDisplayStep.removeActionListener(this.m_miDisplayStepActionListener);
            this.m_miDisplayStep = null;
        }
        this.m_miDisplayStepActionListener = null;
        if (this.m_miStatusDetails != null) {
            this.m_miStatusDetails.removeActionListener(this.m_miStatusDetailsActionListener);
            this.m_miStatusDetails = null;
        }
        this.m_miStatusDetailsActionListener = null;
        if (this.m_miInformationStack != null) {
            this.m_miInformationStack.removeActionListener(this.m_miInformationStackActionListener);
            this.m_miInformationStack = null;
        }
        this.m_miInformationStackActionListener = null;
        if (this.m_miLock != null) {
            this.m_miLock.removeActionListener(this.m_miLockActionListener);
            this.m_miLock = null;
        }
        this.m_miLockActionListener = null;
        if (this.m_miUnlock != null) {
            this.m_miUnlock.removeActionListener(this.m_miUnlockActionListener);
            this.m_miUnlock = null;
        }
        this.m_miUnlockActionListener = null;
        this.m_tableModel = null;
        this.m_tableSorter = null;
        this.m_columnModel = null;
        super.removeReferences();
    }
}

